/*-----------------------------------------------------------------------------

   QUASAR - q-gram Alignment based on Suffix ARrays

   Copyright (C) 1998 Stefan Burkhardt
   Author: Stefan Burkhardt <stburk@mpi-sb.mpg.de>
   This file is part of the QUASAR package.

   QUASAR is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   QUASAR is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the QUASAR package; see the file copying.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  or contact the author. 

-------------------------------------------------------------------------------

  #defines used in the program code
  
  $File$
  $Revision: 1.1 $
  $Date: Wed, 29 Mar 2000 11:07:45 +0200 $

-----------------------------------------------------------------------------*/
#ifndef _Q_DEFINES_H
#define _Q_DEFINES_H

#include <sys/types.h>

/* 8 byte integer */
#define LONG		long long

/* Character used for seperating strings in the .raw and .sset files */
#define SEP_CHAR	0

/* definitions of file access parameters */
#define FILE_BLOCK		1048576

/* Error Codes */
#define FOPEN_FAILED		-101
#define	OUT_OF_VIRTUAL_MEM	-102
#define FREAD_FAILED		-103
#define FWRITE_FAILED		-104

/* definitions of handy functions */
#define MIN(a,b)   ((a)>(b)?(b):(a))
#define LN2 (0.693147180559945)
#define LOG2(x) (log(x)*(1./LN2))

#endif	/* _Q_DEFINES_H */
