/*-----------------------------------------------------------------------------

   QUASAR - q-gram Alignment based on Suffix ARrays

   Copyright (C) 1998 Stefan Burkhardt
   Author: Stefan Burkhardt <stburk@mpi-sb.mpg.de>
   This file is part of the QUASAR package.

   QUASAR is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   QUASAR is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the QUASAR package; see the file copying.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  or contact the author. 

-------------------------------------------------------------------------------

  index structure module
  
  $File$
  $Revision: 1.3 $
  $Date: Wed, 29 Mar 2000 11:07:45 +0200 $

-----------------------------------------------------------------------------*/

#ifndef _Q_INDEX_H
#define _Q_INDEX_H

#include <string.h>
#include "q_misc.h"
#include "q_sset.h"
#include "q_defines.h"

typedef struct q_index{
  int		*sa;	/* pointer to the suffix array */
  int		q;	/* chosen qgram length */
  int		n;	/* number of possible q-grams */
  int		*sr;    /* precomputed search results */
} Q_Index;

Q_Index *NewIndex();
/*  Creates and initializes an index */

void DeleteIndex(Q_Index *index);
/* Frees all memory allocated for index */

Q_Index *ReadIndex(char *infile, int q);
/*  Read the index from infile.sa and read precomputed searches for q-grams
    of length q from infile.q */

int *GetHits(Q_Index *index, LONG qgram, int *hits);
/*  Get the hitlist for qgram, write its length to hits and return a 
    pointer to the start of the hitlist */

int GetLongHits(Q_SSet *sset, char *seq, Q_Index *index, int q, LONG qgram, int *hits, int *n);
/*  Get the hitlist for qgram where qgram is of length q but still use
    the index (which contains precomputed searches for shorter qgrams ).
    hits is a pointer to the leftmost occurence of the shorter q-grams
    and n is the number of occurences of the shorter q-grams. A binary
    search between these two hits is performed to find the real *hits and n
    these are set accordingly */

void PrintIndexInfo(Q_Index *index);
/*  Prints index information */

void PrintIndex(Q_Index *index);
/*  Prints complete index */

void PrintIndexStatistics(Q_Index *index);
/*  Prints index statistics */

#endif	/* _Q_INDEX_H */

