/*-----------------------------------------------------------------------------

   QUASAR - q-gram Alignment based on Suffix ARrays

   Copyright (C) 1998 Stefan Burkhardt
   Author: Stefan Burkhardt <stburk@mpi-sb.mpg.de>
   This file is part of the QUASAR package.

   QUASAR is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   QUASAR is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the QUASAR package; see the file copying.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  or contact the author. 

-------------------------------------------------------------------------------

  option handling
  
  $File$
  $Revision: 1.4 $
  $Date: Wed, 16 Feb 2000 16:16:22 +0100 $

-----------------------------------------------------------------------------*/
#ifndef _Q_OPTION_H
#define _Q_OPTION_H



#include <stdio.h>
#include "q_misc.h"

#define		NUM_OPTIONS			9
#define		Q_OPTIONS_CORRUPT_FILE		-1

typedef struct q_options{
  int	q;		  /* length of q-grams */
  int	i;		  /* length of q-grams used in index */
  int	w;		  /* length of search window */
  int	t;		  /* block threshold for filtering */
  int	b;		  /* block size */
  int	filter_mode;	  /* search mode, 0 = exact, 1 = 1-neighbourhood */
  int	output_mode;	  /* output : 0 = filtered to disk, 1 = call BLAST */
  int	rquery;		  /* turns reverse query search on (=1) or off (=0) */
  int	rep_cutoff;	  /* 0 = consider all hits, >0 consider hits that are
			     less frequent than rep_cutoff */
} Q_Options;


Q_Options *NewOptions();
/*  Creates and initializes an options datastructure */

void DeleteOptions(Q_Options *op);
/* Frees all memory allocated for op */

void PrintOptions(Q_Options *op);
/*  Prints all options set in op */

Q_Options *ReadOptions(char *infile);
/*  Read all user options from the file named infile */

#endif	/* _Q_OPTION_H */
